% Detektion av vikt hos person som stter sig en kontorsstol
%Modellering och detektionsmetod r beskriven i ppt
%ExempelStol2013apr30.pptx
%Anders Hultgren 2013 maj 02

%% parametrar fr kontorsstol
g=10;           %tyngdacceleration
m1=5;           %stolsitsmassa
k=15e3;         %fjderkonstant
b=10e2;         %dmpkonstant


%% parametrar fr person som stter sig
m2=110;         %personvikt
stigtid=0.01%0.1;   %tid fr att stta sig med full vikt
rate=m2/stigtid;

%% parametrar anvnda vid detektering
%tauv=0.01;     %filtrering av deriverad hastighetssignal
m1m=m1;         %antagen stolsitsmassa         
km=k;           %antagen fjderkonstant
bm=b;           %antagen dmpkonstant
gm=g;           %antagen tyngdacceleration
tau=0.01;       %residualfiltrering
mlimit=100;     %maximal tillten vikt

%% parametrar fr brus
Tsamp=0.001;
snoise=1e-9;
vnoise=1e-9;

%% parametrar fr simulering
Tsim=2;

%% simulering
%sim('stolmdl',Tsim)
sim('stolmdl5',Tsim)

%% diagram
figure(1)

plot(t,s,t,sm,t,detekt/12)
title('Kontorsstol, sitsposition nr person stter sig')
xlabel('Tid [sek]'), ylabel('stolsitslge [m]')
legend('stolsitslge','stolsitslgesmtsignal',...
    'grnsviktdetektion',...
    'Location','NorthWest')

figure (2)
plot(t,m2estfilt)
title('Residual fr personvikt, kontorsstolsfrsk')
xlabel('Tid [sek]'), ylabel('Estimerad personvikt [kg]')